// ==UserScript==
// @name         5ch オリジナルアンカーリンク（オリジナルポップアップ用）
// @namespace    http://tampermonkey.net/
// @version      1.2
// @description  スレ内アンカーリンクでジャンプ＆ハイライト + AAレスのspan→div変換対応
// @author       ChatGPT
// @match        *://*.5ch.net/test/read.cgi/*
// @grant        none
// ==/UserScript==

(function () {
    'use strict';

    const offsetPx = 200;
    const highlightColor = 'rgba(255, 215, 0, 0.8)';
    const highlightDuration = 1500;

    function enableReplyLinkScroll() {
        document.addEventListener('click', function (event) {
            const link = event.target.closest('a, span.custom_reply');
            if (!link) return;

            let postId = null;

            if (link.tagName.toLowerCase() === 'a') {
                if (!/^>>\d+$/.test(link.textContent)) return;
                postId = link.textContent.replace('>>', '');
            } else if (link.classList.contains('custom_reply')) {
                const href = link.getAttribute('data-href');
                if (!href) return;
                const match = href.match(/\/(\d+)$/);
                if (!match) return;
                postId = match[1];
            } else {
                return;
            }

            event.preventDefault();

            const target = document.querySelector(`[data-id="${postId}"]`);
            if (!target) {
                console.warn(`data-id="${postId}" の要素が見つかりません`);
                return;
            }

            const originalBoxShadow = target.style.boxShadow;
            const originalBorderBottom = target.style.borderBottom;
            const originalBorderColor = target.style.borderColor;
            const originalPosition = target.style.position;
            const originalZIndex = target.style.zIndex;

            const rect = target.getBoundingClientRect();
            const absoluteTop = window.scrollY + rect.top;
            window.scrollTo({
                top: absoluteTop - offsetPx,
                behavior: 'smooth'
            });

            target.style.position = 'relative';
            target.style.zIndex = '10';
            target.style.transition = 'box-shadow 0.5s ease-in-out, border-color 0.3s ease';
            target.style.borderBottom = 'none';
            target.style.boxShadow = `inset 0 -1px 0 0 #eee, 0 0 12px 4px ${highlightColor}`;

            setTimeout(() => {
                target.style.boxShadow = originalBoxShadow || '';
                target.style.borderBottom = originalBorderBottom || '1px solid #eee';
                target.style.borderColor = 'transparent';
            }, highlightDuration);

            setTimeout(() => {
                target.style.borderColor = originalBorderColor || 'rgb(238, 238, 238)';
                target.style.position = originalPosition || '';
                target.style.zIndex = originalZIndex || '';
            }, highlightDuration + 500);
        });
    }

    // AA custom_reply span を div に変換する処理
    function convertAAToDiv() {
        const aaSpans = document.querySelectorAll('span.AA.custom_reply');
        aaSpans.forEach(span => {
            if (span.querySelector('span.custom_reply')) {
                const div = document.createElement('div');
                div.className = span.className;
                div.setAttribute('data-post-id', span.getAttribute('data-post-id'));
                div.innerHTML = span.innerHTML;
                span.replaceWith(div);
            }
        });
    }

    function init() {
        convertAAToDiv();           // AA span→div変換
        enableReplyLinkScroll();    // アンカーリンク動作
    }

    if (document.readyState === 'loading') {
        window.addEventListener('DOMContentLoaded', init);
    } else {
        init();
    }
})();
